﻿<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.HR" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">
    
    public enum Zakres {
        Uzyskane, Utracone, Ważne, Wszystkie
    }
    
    public class Params : ContextBase {

        public Params(Context context): base(context) {
            okres = GetOkres();
        }

        DefinicjaUprawnienia[] uprawnienia;
        [Priority(10)]
        public DefinicjaUprawnienia[] Uprawnienia {
            get { return uprawnienia; }
            set {
                uprawnienia = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListUprawnienia() {
            HRModule hr = HRModule.GetInstance(this);
            Soneta.Business.View v = hr.DefUprawnien.WgNazwy.CreateView();
            v.Condition &= new FieldCondition.NotEqual("Blokada", true);
            return v;
        }

        Zakres zakres = Zakres.Ważne;
        [Priority(20)]
        public Zakres Zakres {
            get { return zakres; }
            set {
                zakres = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        FromTo okres;
        [Required]
        [Caption("Okres")]
        [Priority(30)]
        public FromTo Okres {
            get { return okres; }
            set {
                if (value == FromTo.Empty)
                    value = GetOkres();
                okres = value;
                OnChanged(EventArgs.Empty);
            }
        }
    
        FromTo GetOkres() {
            return new YearMonth(ActualDate.Today(Context)).ToFromTo();
        }
    }

    [Context]
    public Params Pars {
        set {
            uprawnienia = value.Uprawnienia;
            zakres = value.Zakres;
            okres = value.Okres;
        }
    }
    
    DefinicjaUprawnienia[] uprawnienia;
    Zakres zakres;
    FromTo okres;

    RowCondition condition = RowCondition.Empty;

    protected void dc_ContextLoad(object sender, EventArgs e) {        
        ReportHeader["UPRAWNIENIA"] = Info("Uprawnienie", "Uprawnienia", uprawnienia);
        ReportHeader["INFO"] = CaptionAttribute.EnumToString(zakres);

        colWydzial.Visible = false;
        if (dc.Context.Contains(typeof(Soneta.Kadry.Forms.KadryPracownicyViewInfo.PrParams))) {
            colWydzial.Visible = true;
            ReportHeader.DataMember0 = "KadryPracownicyViewInfo+PrParams.Wydział";
            ReportHeader.DataMember1 = "KadryPracownicyViewInfo+PrParams.Pośrednio"; 
            ReportHeader.DataMember2 = "KadryPracownicyViewInfo+PrParams.Okres"; 
            ReportHeader.DataMember3 = "KadryPracownicyViewInfo+PrParams.Aktualny";
        }
        else if (dc.Context.Contains(typeof(Soneta.Kadry.Forms.KadryZleceniobiorcyViewInfo.ZlParams))) {
            ReportHeader.DataMember0 = "KadryZleceniobiorcyViewInfo+ZlParams.Wydział"; 
            ReportHeader.DataMember1 = "KadryZleceniobiorcyViewInfo+ZlParams.Pośrednio"; 
            ReportHeader.DataMember2 = "KadryZleceniobiorcyViewInfo+ZlParams.Okres"; 
            ReportHeader.DataMember3 = "KadryZleceniobiorcyViewInfo+ZlParams.Aktualny";
        }

        if (uprawnienia != null && uprawnienia.Length > 0)
            condition &= new FieldCondition.In("Definicja", uprawnienia);

        switch (zakres) {
            case Zakres.Uzyskane:
                condition &= RowCondition.ContainsIn("Okres.From", okres);
                break;
            case Zakres.Utracone:
                condition &= RowCondition.ContainsIn("Okres.To", okres); 
                break;
            case Zakres.Ważne:
                condition &= RowCondition.IsIntersected("Okres", okres); 
                break;
        }

        bool visible = uprawnienia == null || uprawnienia.Length != 1;
        if (!visible) {
            colUprawenienie.Visible = false;
            dc.Landscape = false;
        }
    }

    protected void Grid_BeforeRow(object sender, RowEventArgs args) {
        Pracownik idx = (Pracownik)args.Row;
        HRModule hr = HRModule.GetInstance(idx);
        SubTable st = hr.UprawnieniaPrac.WgPracownik[idx];
        st = st[condition];

        bool any = false;
        foreach (UprawnieniePracownika upp in st) {
            any = true;
            colKategoria.AddLine(upp.Kategoria);
            colUprawenienie.AddLine(upp.Definicja.Nazwa);
            colUzyskanie.AddLine(upp.DataUzyskania);
            colTermin.AddLine(upp.TerminWaznosci);
            colUtrata.AddLine(upp.DataUtraty);
        }

        args.VisibleRow = any;
    }

    static string Info(string singleLabel, string multiLabel, params object[] lst) {
        if (lst == null || lst.Length == 0)
            return "";
        else if (lst.Length == 1)
            return string.Format("</strong>|{0}: <strong>{1}", singleLabel, lst[0]);
        string info = "";
        foreach (object obj in lst)
            if (info == "")
                info = obj.ToString();
            else
                info += "</strong>, <strong>" + obj.ToString();
        return string.Format("</strong>|{0}: <strong>{1}", multiLabel, info);
    }

    public static void Msg(object value) {
    }
    
</script>

<HTML>
	<HEAD>
		<TITLE>Znajomość języków obcych</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad" 
                Landscape="True"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" 
                title="Uprawnienia pracowników&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;BR&gt;&lt;/strong&gt;Wydział: &lt;strong&gt;{0}&lt;BR&gt;&lt;/strong&gt;Pośrednio: &lt;strong&gt;{1}&lt;BR&gt;&lt;/strong&gt;Okres: &lt;strong&gt;{2}&lt;BR&gt;&lt;/strong&gt;Aktualny: &lt;strong&gt;{3}%UPRAWNIENIA%&lt;BR&gt;&lt;/strong&gt;Zakres: &lt;strong&gt;%INFO%&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" 
                RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace" 
                onbeforerow="Grid_BeforeRow">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Nazwisko" EncodeHTML="true" Caption="Nazwisko"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Imie" EncodeHTML="true" 
                        Caption="Imie" Width="16" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Kod" EncodeHTML="true" 
                        Caption="Kod" Width="16" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" ID="colWydzial"
                        DataMember="Workers.Info.Historia.Etat.Wydzial.Kod" EncodeHTML="true" 
                        Caption="Wydział" Width="16" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn ID="colKategoria" runat="server" Align="Left" 
                        EncodeHTML="true" Caption="Kategoria" Width="16"></ea:GridColumn>
				    <ea:GridColumn ID="colUprawenienie" runat="server" Caption="Uprawnienia~Nazwa" NoWrap="True" 
                        Width="40" VAlign="Top">
                    </ea:GridColumn>
				    <ea:GridColumn ID="colUzyskanie" runat="server" BgColor="" 
                        Caption="Uprawnienia~data uzyskania" CssClass="" FontColor="" FontFamily="" 
                        FontSize="" Width="12" WithBarcode="None" Format="{0:b}&amp;nbsp;" 
                        NoWrap="True" Align="Center">
                    </ea:GridColumn>
                    <ea:GridColumn ID="colTermin" runat="server" BgColor="" 
                        Caption="Uprawnienia~termin ważności" CssClass="" FontColor="" FontFamily="" 
                        FontSize="" Width="12" WithBarcode="None" Format="{0:b}&amp;nbsp;" 
                        NoWrap="True" Align="Center">
                    </ea:GridColumn>
                    <ea:GridColumn ID="colUtrata" runat="server" BgColor="" 
                        Caption="Uprawnienia~data utraty" CssClass="" FontColor="" FontFamily="" 
                        FontSize="" Width="12" WithBarcode="None" Format="{0:b}&amp;nbsp;" 
                        NoWrap="True" Align="Center">
                    </ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

